/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.events;

import com.google.common.collect.Lists;
import com.ninni.etcetera.client.TidalHelmetHud;
import com.ninni.etcetera.client.gui.HandbellItemRenderer;
import com.ninni.etcetera.client.gui.screen.PricklyCanScreen;
import com.ninni.etcetera.client.model.ChappleModel;
import com.ninni.etcetera.client.model.CottonArmorModel;
import com.ninni.etcetera.client.model.TurtleRaftModel;
import com.ninni.etcetera.client.renderer.block.entity.ItemStandBlockEntityRenderer;
import com.ninni.etcetera.client.renderer.entity.ChappleRenderer;
import com.ninni.etcetera.client.renderer.entity.TurtleRaftRenderer;
import com.ninni.etcetera.registry.EtceteraBlockEntityType;
import com.ninni.etcetera.registry.EtceteraEntityModelLayers;
import com.ninni.etcetera.registry.EtceteraEntityType;
import com.ninni.etcetera.registry.EtceteraItems;
import com.ninni.etcetera.registry.EtceteraScreenHandlerType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="etcetera", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)EtceteraScreenHandlerType.PRICKLY_CAN.get()), PricklyCanScreen::new);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.register((Object)new TidalHelmetHud());
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)EtceteraItems.TURTLE_RAFT.get()});
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)EtceteraBlockEntityType.ITEM_STAND.get(), ItemStandBlockEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EtceteraEntityType.TURTLE_RAFT.get(), TurtleRaftRenderer::new);
        event.registerEntityRenderer((EntityType)EtceteraEntityType.CHAPPLE.get(), ChappleRenderer::new);
        event.registerEntityRenderer((EntityType)EtceteraEntityType.EGGPLE.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(EtceteraEntityModelLayers.TURTLE_RAFT, TurtleRaftModel::createLayerDefinition);
        event.registerLayerDefinition(EtceteraEntityModelLayers.CHAPPLE, ChappleModel::createLayerDefinition);
        event.registerLayerDefinition(EtceteraEntityModelLayers.PLAYER_COTTON, CottonArmorModel::createLayerDefinition);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)HandbellItemRenderer.INVENTORY_IN_HAND_MODEL_ID);
    }

    @SubscribeEvent
    public static void onCreativeModeTabsBuilt(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (tabKey == CreativeModeTabs.f_256788_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42334_, (ItemLike)EtceteraItems.BISMUTH_BLOCK.get(), (ItemLike)EtceteraItems.BISMUTH_BARS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41923_, (ItemLike)EtceteraItems.LEVELED_STONE.get(), (ItemLike)EtceteraItems.CRUMBLING_STONE.get(), (ItemLike)EtceteraItems.WAXED_CRUMBLING_STONE.get(), (ItemLike)EtceteraItems.LEVELED_STONE_STAIRS.get(), (ItemLike)EtceteraItems.LEVELED_STONE_SLAB.get());
        }
        if (tabKey == CreativeModeTabs.f_256791_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42779_, (ItemLike)EtceteraItems.LIGHT_BULB.get(), (ItemLike)EtceteraItems.TINTED_LIGHT_BULB.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42001_, (ItemLike)EtceteraItems.SQUID_LAMP.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42251_, (ItemLike)EtceteraItems.IRIDESCENT_LANTERN.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41984_, (ItemLike)EtceteraItems.DRUM.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42340_, (ItemLike)EtceteraItems.FRAME.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271478_, (ItemLike)EtceteraItems.TERRACOTTA_VASE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151063_, (ItemLike)EtceteraItems.ITEM_STAND.get(), (ItemLike)EtceteraItems.GLOW_ITEM_STAND.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42108_, (ItemLike)EtceteraItems.PRICKLY_CAN.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_276672_, (ItemLike)EtceteraItems.CRUMBLING_STONE.get(), (ItemLike)EtceteraItems.WAXED_CRUMBLING_STONE.get());
        }
        if (tabKey == CreativeModeTabs.f_257028_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42151_, (ItemLike)EtceteraItems.DRUM.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41870_, (ItemLike)EtceteraItems.DICE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42768_, (ItemLike)EtceteraItems.PRICKLY_CAN.get());
        }
        if (tabKey == CreativeModeTabs.f_256731_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42551_, (ItemLike)EtceteraItems.CHAPPLE_SPAWN_EGG.get());
        }
        if (tabKey == CreativeModeTabs.f_256797_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42521_, (ItemLike)EtceteraItems.EGGPLE.get(), (ItemLike)EtceteraItems.GOLDEN_EGGPLE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42354_, (ItemLike)EtceteraItems.TIDAL_HELMET.get(), (ItemLike)EtceteraItems.WHITE_HAT.get(), (ItemLike)EtceteraItems.TRADER_HOOD.get(), (ItemLike)EtceteraItems.WHITE_SWEATER.get(), (ItemLike)EtceteraItems.TRADER_ROBE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42713_, (ItemLike)EtceteraItems.HAMMER.get());
        }
        if (tabKey == CreativeModeTabs.f_256869_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271356_, (ItemLike)EtceteraItems.HAMMER.get(), (ItemLike)EtceteraItems.CHISEL.get(), (ItemLike)EtceteraItems.WRENCH.get(), (ItemLike)EtceteraItems.HANDBELL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_244260_, (ItemLike)EtceteraItems.TURTLE_RAFT.get());
        }
        if (tabKey == CreativeModeTabs.f_256776_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41836_, (ItemLike)EtceteraItems.NETHER_BISMUTH_ORE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150997_, (ItemLike)EtceteraItems.RAW_BISMUTH_BLOCK.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271209_, (ItemLike)EtceteraItems.BOUQUET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42733_, (ItemLike)EtceteraItems.COTTON_SEEDS.get());
        }
        if (tabKey == CreativeModeTabs.f_256725_) {
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42246_, (ItemLike)EtceteraItems.IRIDESCENT_CONCRETE.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41870_, (ItemLike)EtceteraItems.IRIDESCENT_WOOL.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42230_, (ItemLike)EtceteraItems.IRIDESCENT_GLAZED_TERRACOTTA.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42199_, (ItemLike)EtceteraItems.IRIDESCENT_TERRACOTTA.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41904_, (ItemLike)EtceteraItems.IRIDESCENT_GLASS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42027_, (ItemLike)EtceteraItems.IRIDESCENT_GLASS_PANE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42509_, (ItemLike)EtceteraItems.WHITE_SWEATER.get(), (ItemLike)EtceteraItems.LIGHT_GRAY_SWEATER.get(), (ItemLike)EtceteraItems.GRAY_SWEATER.get(), (ItemLike)EtceteraItems.BLACK_SWEATER.get(), (ItemLike)EtceteraItems.BROWN_SWEATER.get(), (ItemLike)EtceteraItems.RED_SWEATER.get(), (ItemLike)EtceteraItems.ORANGE_SWEATER.get(), (ItemLike)EtceteraItems.YELLOW_SWEATER.get(), (ItemLike)EtceteraItems.LIME_SWEATER.get(), (ItemLike)EtceteraItems.GREEN_SWEATER.get(), (ItemLike)EtceteraItems.CYAN_SWEATER.get(), (ItemLike)EtceteraItems.LIGHT_BLUE_SWEATER.get(), (ItemLike)EtceteraItems.BLUE_SWEATER.get(), (ItemLike)EtceteraItems.PURPLE_SWEATER.get(), (ItemLike)EtceteraItems.MAGENTA_SWEATER.get(), (ItemLike)EtceteraItems.PINK_SWEATER.get(), (ItemLike)EtceteraItems.WHITE_HAT.get(), (ItemLike)EtceteraItems.LIGHT_GRAY_HAT.get(), (ItemLike)EtceteraItems.GRAY_HAT.get(), (ItemLike)EtceteraItems.BLACK_HAT.get(), (ItemLike)EtceteraItems.BROWN_HAT.get(), (ItemLike)EtceteraItems.RED_HAT.get(), (ItemLike)EtceteraItems.ORANGE_HAT.get(), (ItemLike)EtceteraItems.YELLOW_HAT.get(), (ItemLike)EtceteraItems.LIME_HAT.get(), (ItemLike)EtceteraItems.GREEN_HAT.get(), (ItemLike)EtceteraItems.CYAN_HAT.get(), (ItemLike)EtceteraItems.LIGHT_BLUE_HAT.get(), (ItemLike)EtceteraItems.BLUE_HAT.get(), (ItemLike)EtceteraItems.PURPLE_HAT.get(), (ItemLike)EtceteraItems.MAGENTA_HAT.get(), (ItemLike)EtceteraItems.PINK_HAT.get());
        }
        if (tabKey == CreativeModeTabs.f_256968_) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42521_, (ItemLike)EtceteraItems.EGGPLE.get(), (ItemLike)EtceteraItems.GOLDEN_EGGPLE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151053_, (ItemLike)EtceteraItems.RAW_BISMUTH.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42417_, (ItemLike)EtceteraItems.BISMUTH_INGOT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42405_, (ItemLike)EtceteraItems.COTTON_FLOWER.get());
        }
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addAfter(map, after, blk));
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addBefore(map, before, blk));
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike block) {
        map.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike block) {
        map.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

